/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core.old.handlers;

import com.aptana.core.util.FileUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.old.handlers.SyncEventHandlerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SyncEventHandlerAdapterWithProgressMonitor
extends SyncEventHandlerAdapter {
    private static final int TRANSFER_SCALE = 1024;
    private static final int PATH_DISPLAY_CHARACTERS = 40;
    private IProgressMonitor monitor;
    private Map<VirtualFileSyncPair, SubProgressMonitor> itemsProgress = new HashMap<VirtualFileSyncPair, SubProgressMonitor>();
    private Map<VirtualFileSyncPair, Long> itemsTransfer = new HashMap<VirtualFileSyncPair, Long>();

    public SyncEventHandlerAdapterWithProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
    }

    public boolean getFilesEvent(IConnectionPoint manager, String path) {
        this.monitor.subTask(FileUtil.compressPath((String)path, (int)40));
        return !this.monitor.isCanceled() && super.getFilesEvent(manager, path);
    }

    public boolean syncContinue(IProgressMonitor monitor) {
        return !monitor.isCanceled() && super.syncContinue(monitor);
    }

    public void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor != null) {
            itemProgressMonitor.done();
            this.itemsProgress.remove(item);
            this.itemsTransfer.remove(item);
        }
        super.syncDone(item, monitor);
    }

    public boolean syncErrorEvent(VirtualFileSyncPair item, Exception e, IProgressMonitor monitor) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor != null) {
            itemProgressMonitor.done();
            this.itemsProgress.remove(item);
            this.itemsTransfer.remove(item);
        }
        return !monitor.isCanceled() && super.syncErrorEvent(item, e, monitor);
    }

    public boolean syncEvent(VirtualFileSyncPair item, int index, int totalItems, IProgressMonitor monitor) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor == null && item != null) {
            itemProgressMonitor = new SubProgressMonitor(monitor, 1);
            this.itemsProgress.put(item, itemProgressMonitor);
            this.itemsTransfer.put(item, 0L);
            monitor.subTask(FileUtil.compressPath((String)item.getRelativePath(), (int)40));
            itemProgressMonitor.beginTask(item.getRelativePath(), SyncEventHandlerAdapterWithProgressMonitor.getItemProgressAmount(item));
        }
        return !monitor.isCanceled() && super.syncEvent(item, index, totalItems, monitor);
    }

    public void syncTransferring(VirtualFileSyncPair item, long bytes, IProgressMonitor monitor) {
        SubProgressMonitor itemProgressMonitor = this.itemsProgress.get(item);
        if (itemProgressMonitor != null) {
            long delta = bytes - this.itemsTransfer.get(item);
            this.itemsTransfer.put(item, bytes);
            itemProgressMonitor.worked((int)(delta / 1024L));
        }
        super.syncTransferring(item, bytes, monitor);
    }

    private static int getItemProgressAmount(VirtualFileSyncPair item) {
        switch (item.getSyncDirection()) {
            case 1: {
                return (int)(item.getSourceFile().fetchInfo().getLength() / 1024L);
            }
            case 2: {
                return (int)(item.getDestinationFile().fetchInfo().getLength() / 1024L);
            }
        }
        return 1;
    }
}

